	clear all
	close all
	clc
	
	wcT = 0.2*pi;	wsT = 0.4*pi;	Amin = 60;	Amax = 0.2;
	N = 21; phError = 0.3*pi/180; % 0.3 degree	
	[G, Z, P] = L_PHASE_LATTICE_WDF(wcT, wsT, Amax, Amin, phError, N);
	% Single allpass branch, select alfa_odd
	[alfa_odd, alfa_even]= CASCADE_RICHARDS_SECTIONS(P, []); 
	M = (N-1)/2;
 
	figure(1)
	% Compute the zeros of the overall transfer function
	Z = roots([poly(P),zeros(1,M)] + [zeros(1,M),poly(Z)]);	
	P = [P; zeros(M,1)];
	PLOT_PZ_Z(Z, P)
	
	figure(2)
	wT = linspace(0, pi,1000);
	[S1, S2] = L_PHASE_LATTICE_RICHARDS_H(alfa_odd, M, wT);
	Att = H_2_ATT(0.5*(S2 - S1));
	subplot('position', [0.08 0.4 0.90 0.5]);
	PLOT_ATT_Z(wT, Att, pi, 80)	
	axes('position',[0.60 0.52 0.3 0.2]);
	wT = linspace(0, 0.2*pi,1000);
	[S1, S2] = L_PHASE_LATTICE_RICHARDS_H(alfa_odd, M, wT);
	Att = H_2_ATT(0.5*(S2-S1));
	PLOT_ATT_Z_LS(wT, Att, 10^-4)
	
	figure(3)
	subplot(3,1,1)
	[S1, S2] = L_PHASE_LATTICE_RICHARDS_H(alfa_odd, M, wT);
	H = 0.5*(S2 - S1);
	Ph_error = unwrap(angle(H)) + 10*wT;
	PLOT_DELTA_PHASE_Z(wT, Ph_error, -5*10^-3, 5*10^-3)	
	subplot(3,1,2)
	Taug = PZ_2_TG_Z(G, Z, P, wT);	
 	PLOT_TG_Z(wT, Taug,  19.5, 20.5)
	
